/* DYN2DARR.C */

#include <stdlib.h>
#include "dyn2darr.h"

void **dyn2darray( unsigned row, unsigned col, unsigned el_size)
{
       /* Offset to first address past pointers at which an */
       /* unsigned COULD be stored             */
  unsigned FirstUnsignOff = Dyn2dRndUp(row * sizeof (void *),
                  sizeof (unsigned));
  unsigned SpaceBeforeObj = Dyn2dRndUp(FirstUnsignOff
            + 2*sizeof (unsigned), el_size);
  unsigned SpaceForObj  = row * col * el_size;
  unsigned *PtrToRows;
  unsigned c;
  char   *p = NULL;
  void   **arr = (void **) calloc(SpaceBeforeObj + SpaceForObj,
                sizeof( char ));

  if ( arr == NULL )
  return NULL;

  p       = (char *) arr;
  PtrToRows   = (unsigned *) (p + Dyn2dRndDown(SpaceBeforeObj,
              sizeof (unsigned))) - 2;
  PtrToRows[0]  = row;
  PtrToRows[1]  = col;          /* Store cols after rows  */
                    /* Offset to end of cols  */
  p       = p + SpaceBeforeObj;   /* pointer to first object */

                    /* Link rows to pointers  */
  for( c = 0; c < row; ++c ) {
 arr[c] = p + ( c * col * el_size);
  }

  return arr;
}

/* End of File */
