Listing 6 - a test program for the hierarchy in Listing 5.

int main()
    {
    C c;
    D d;

    B *pb = &c;         // ok, &c is a C * which is a B *
    pb->f(1);           // calls C::f(int)
    pb->f(2L);          // calls B::f(long)
    pb->f("hello");     // calls B::f(char *)

    d.f(1);             // calls D::f(long)
                        // C::f(int) is hidden
                        // but 1 promotes to long
    d.C::f(1);          // calls C::f(int)
    d.B::f(1);          // calls B::f(int)
    d.f(1L);            // calls D::f(long)
    d.C::f(1L);         // calls C::f(int)
                        // B::f(long) is hidden
                        // but 1L converts to int
    d.B::f(1L);         // calls B::f(long)

    C *pc = &d;         // ok, &d is a D * which is a C *
    pc->f(1);           // calls C::f(int)
    pc->f(1L);          // calls C::f(int)
                        // B::f(long) is hidden
                        // but 1L converts to int
    pc->B::f(1L);       // calls B::f(long)
    pc->f("hello");     // error!  f(char *) is hidden
    pc->B::f("hello");  // calls B::f(char *)

    B &rb = *pc;        // ok, *pc is a C which is a B
    rb.f(1);            // calls C::f(int)
    rb.f(2L);           // calls D::f(long)
    rb.B::f(2L);        // calls B::f(long)
    rb.f("hello");      // calls B::f(char *)

    return 0;
    }
