#define BASE  94        /* # possible output chars */
#define FIRST_CODE  '!' /* lowest output char      */
#define PBASE   56      /* prefix base             */
#define BASESQ  (unsigned long)(BASE*BASE)
#define MAKE_PRINT(c)  (char)((c)+FIRST_CODE)
#define CV2ASCII(p,v)  (*(p)=MAKE_PRINT((v)/BASE), \
                        *(p+1)=MAKE_PRINT((v)%BASE))
#define PBMULT (unsigned)(((0xffffffffUL/PBASE)>>16)+1)
...
/* Encode 9 bytes into 11 printable ASCII chars.    */
   unsigned long block; /* conversion area      */
   int         i;       /* input byte index     */
   unsigned int qb = 0; /* prefixes             */
   ldiv_t      ld;      /* quotient, remainder  */

   for (i = 1; i < 9; i += 4) {
      unsigned    q;
      block = ((unsigned long)
               (((unsigned)in[i+0]<<8) | in[i+1])<<16)+
              (((unsigned) in[i+2]<<8) | in[i+3]);

      q = (unsigned) (block >> 16) / PBMULT;
      block = block- ((unsigned long)(q*PBMULT) << 16);
      ld = ldiv ((long) block, (long) BASESQ);
      CV2ASCII(out+i+2, (unsigned) ld.quot);
      CV2ASCII(out+i+4, (unsigned) ld.rem);
      qb = qb * PBASE + q;
   }

   /* Now convert the remaining byte and prefixes
    * from previous block conversions               */
   block = ((unsigned long) qb << 8) | in[0];
   ld = ldiv ((long) block, (long) BASESQ);
   out[0] = MAKE_PRINT((unsigned) ld.quot);
   CV2ASCII(out+1, (unsigned) ld.rem);

/* End of File */ 

