template<unsigned long N>
class bits
{
// Friends:
    // Global I/O funtions
    friend ostream& operator<<(ostream&, const bits<N>&);
    friend istream& operator>>(istream&, bits<N>&);

    // Global bitwise operators
    friend bits<N> operator&(const bits<N>&, const bits<N>&);
    friend bits<N> operator|(const bits<N>&, const bits<N>&);
    friend bits<N> operator^(const bits<N>&, const bits<N>&);

public:
    // Constructors
    bits();
    bits(unsigned long n);
    bits(const bits<N>& b);
    bits(const string& s);

    // Conversions
    unsigned short to_ushort() const;
    unsigned long to_ulong() const;
    string to_string() const;

    // Assignment
    bits<N>& operator=(const bits<N>& rhs);

    // Equality
    int operator==(const bits<N>& rhs) const;
    int operator!=(const bits<N>& rhs) const;

    // Basic bit operations
    bits<N>& set(size_t pos, int val = 1);
    bits<N>& set();
    bits<N>& reset(size_t pos);
    bits<N>& reset();
    bits<N>& toggle(size_t pos);
    bits<N>& toggle();
    bits<N> operator~() const;
    int test(size_t n) const;
    int any() const;
    int none() const;

    // Bit-wise operators
    bits<N>& operator&=(const bits<N>& rhs);
    bits<N>& operator|=(const bits<N>& rhs);
    bits<N>& operator^=(const bits<N>& rhs);

    // Shift operators
    bits<N>& operator<<=(size_t n);
    bits<N>& operator>>=(size_t n);
    bits<N> operator<<(size_t n) const;
    bits<N> operator>>(size_t n) const;

    size_t count() const;

    size_t length() const;
};

// End of File

