#if !defined(INTSET_H)
#define INTSET_H

#include <iostream.h>
#include <stddef.h>
#include "bits.h"

template<size_t N>
class Intset
{
public:
    // NOTE: The following constructors shouldn't be
    // necessary. The compiler-generated ones should
    // suffice. For some reason, Borland 3.1 requires
    // these (WATCOM does not).

    // Constructors
    Intset();
    Intset(const Intset<N>& is);

    // Set operations
    Intset<N> operator-(const Intset<N>& is) const;
    Intset<N> operator+(const Intset<N>& is) const;
    Intset<N> operator*(const Intset<N>& is) const;
    Intset<N> operator~() const;
    int operator==(const Intset<N>& is) const;
    int operator!=(const Intset<N>& is) const;
    int operator<=(const Intset<N>& is) const;
    int operator>=(const Intset<N>& is) const;

    // Member operations
    int contains(size_t n) const;
    Intset<N>& insert(size_t n);
    Intset<N>& remove(size_t n);

    size_t count() const;
    friend ostream& operator<<(ostream& os, const Intset<N>& 
is)
      {is.print(os); return os;}

private:
    bits<N> bitset;

    int subsetof(const Intset<N>& is) const;
    void print(ostream& os) const;
};

template<size_t N>
Intset<N>::Intset()
{
    bitset.reset();
}

template<size_t N>
Intset<N>::Intset(const Intset<N>& is)
{
    bitset = is.bitset;
}

template<size_t N>
inline Intset<N> Intset<N>::operator-(const Intset<N> &is) const
{
    Intset<N> r(*this);
    r.bitset &= ~is.bitset;
    return r;
}

template<size_t N>
inline Intset<N> Intset<N>::operator+(const Intset<N> &is) const
{
    Intset<N> r(*this);
    r.bitset |= is.bitset;
    return r;
}

template<size_t N>
inline Intset<N> Intset<N>::operator*(const Intset<N> &is) const
{
    Intset<N> r(*this);
    r.bitset &= is.bitset;
    return r;
}

template<size_t N>
inline Intset<N> Intset<N>::operator~() const
{
    Intset<N> r(*this);
    r.bitset.toggle();
    return r;
}

template<size_t N>
inline int Intset<N>::operator==(const Intset<N> &is) const
{
    return bitset == is.bitset;
}

template<size_t N>
inline int Intset<N>::operator!=(const Intset<N> &is) const
{
    return bitset != is.bitset;
}

template<size_t N>
inline int Intset<N>::operator<=(const Intset<N> &is) const
{
    return subsetof(is);
}

template<size_t N>
inline int Intset<N>::operator>=(const Intset<N> &is) const
{
    return is.subsetof(*this);
}

template<size_t N>
inline int Intset<N>::contains(size_t n) const
{

    return bitset.test(n);
}

template<size_t N>
inline Intset<N>& Intset<N>::insert(size_t n)
{
    bitset.set(n);
    return *this;
}

template<size_t N>
inline Intset<N>& Intset<N>::remove(size_t n)
{
    bitset.reset(n);
    return *this;
}

template<size_t N>
inline size_t Intset<N>::count() const
{
    return bitset.count();
}

template<size_t N>
inline int Intset<N>::subsetof(const Intset<N>& is) const
{
    bits<N> r(bitset);
    r &= is.bitset;
    return bitset == r;
}

template<size_t N>
void Intset<N>::print(ostream& os) const
{
    os << '{';
    int first_time = 1;
    for (int i = 0; i < N; ++i)
        if (bitset.test(i))
        {
            if (!first_time)
                os << ',';
            os << i;
            first_time = 0;
        }
    os << '}';
}

#endif

/* End of File */ 

