// stack1.h: A C++ integer stack class

#include <stddef.h>

class Stack
{
    size_t size;
    int *data;
    int ptr;

public:
    Stack(size_t);
    ~Stack();
    void push(int);
    int pop();
    int empty() const;
    int full() const;
};

inline Stack::Stack(size_t siz)
{
    data = new int[size = siz];
    ptr = 0;
}

inline Stack::~Stack()
{
    delete [] data;
}

inline int Stack::empty() const
{
    return ptr == 0;
}

inline int Stack::full() const
{
    return ptr == size;
}

// End of File

