// stack2.h: A C++ stack class template

#include <stddef.h>

template<class T>
class Stack
{
    size_t size;
    T *data;
    int ptr;

public:
    Stack(size_t);
    ~Stack();
    void push(const T&);
    T pop();
    int empty() const;
    int full() const;
};

template<class T>
inline Stack<T>::Stack(size_t siz)
{
    data = new T[size = siz];
    ptr = 0;
}

template<class T>
inline Stack<T>::~Stack()
{
    delete [] data;
}

template<class T>
void Stack<T>::push(const T& x)
{
    if (ptr < size)
        data[ptr++] = x;
}

template<class T>
T Stack<T>::pop()
{
    if (ptr > 0)
        --ptr;
    return data[ptr];
}

template<class T>
inline int Stack<T>::empty() const
{
    return ptr == 0;
}

template<class T>
inline int Stack<T>::full() const
{

    return ptr == size;
}

// End of File

