// tbits.cpp
#include <iostream.h>
#include <iomanip.h>
#include <stddef.h>
#include <limits.h>
#include "bits.h"

main()
{
    const size_t SIZE = CHAR_BIT * sizeof(unsigned long);
    unsigned long n = 0x12345678;
    bits<SIZE> x(n), y(string("10110")), z(x);

    cout << "Initial x: " << x << endl;
    cout << "Initial y: " << y << endl;
    cout << "Initial z: " << z << endl;
    cout << "Enter new z: ";
    cin >> z;
    cout << "New z: " << z << endl;
    cout << "z == " << z.to_ulong() << endl;
    cout << "y == " << y.to_ushort() << endl;
    cout << "x == " << x.to_ulong() << endl;

    cout << "x: " << x << " (" << x.count()
         << " bits set)" << endl;
    cout << "x == 0x12345678L? " << (x == 0x12345678L) << endl;
    cout << "x: " << x << endl;
    cout << "x: " << hex << setfill('0')
         << setw(sizeof(unsigned long)*2)
         << x.to_ulong() << dec << endl;
    cout << "x <<= 6 == " << (x <<= 6) << endl;
    cout << "x >>= 6 == " << (x >>= 6) << endl;
    cout << "85 == " << bits<SIZE>(85) << endl;
    cout << "x ^ 85 == " << (x ^ 85) << endl;
    cout << "x & 85 == " << (x & 85) << endl;
    cout << "85 & x === " << (85 & x) << endl;
    cout << "~x == " << (~x) << " == "
         << (~x).to_ulong() << endl;

    y = 0x55555550L;
    cout << "y: " << y << " (" << y.count()
         << " bits set)" << endl;
    cout << "y[0]: " << hex << setfill('0')
         << setw(sizeof(unsigned long)*2)
         << y.to_ulong() << dec << endl;
    cout << "x & y == " << (x & y) << endl;
    cout << "x | y == " << (x | y) << endl;
    cout << "x ^ y == " << (x ^ y) << endl;
    cout << "x != y? " << (x != y) << endl;
    return 0;
}

/* Sample Execution:
Initial x: 00010010001101000101011001111000
Initial y: 00000000000000000000000000010110
Initial z: 00010010001101000101011001111000

Enter new z: 101001000100001000001
New z: 00000000000101001000100001000001
z == 1345601
y == 22
x == 305419896
x: 00010010001101000101011001111000 (13 bits set)
x == 0x12345678L? 1
x: 00010010001101000101011001111000
x: 12345678
x <<= 6 == 10001101000101011001111000000000
x >>= 6 == 00000010001101000101011001111000
85 == 00000000000000000000000001010101
x ^ 85 == 00000010001101000101011000101101
x & 85 == 00000000000000000000000001010000
85 & x === 00000000000000000000000001010000
~x == 11111101110010111010100110000111 == 4257982855
y: 01010101010101010101010101010000 (14 bits set)
y[0]: 55555550
x & y == 00000000000101000101010001010000
x | y == 01010111011101010101011101111000
x ^ y == 01010111011000010000001100101000
x != y? 1

// End of File

