//tintset.cpp
#include <iostream.h>
#include "intset.h"

main()
{
    Intset<16> x, y;

    for (int i = 0; i < 10; ++i)
    {
        x.insert(i);
        if (i % 2)
            y.insert(i);
    }

    cout << "x == " << x << endl;
    cout << "y == " << y << endl;
    cout << "y <= x? " << (y <= x) << endl;
    cout << "y >= x? " << (y >= x) << endl;
    cout << "x - y == " << x - y << endl;
    cout << "x + y == " << x + y << endl;
    cout << "x * y == " << x * y << endl;
    cout << "~x == " << ~x << endl;
    cout << "x.contains(2)? " << x.contains(2) << endl;
    cout << "y.contains(2)? " << y.contains(2) << endl;
    cout << "x.count() == " << x.count() << endl;
    cout << "y.count() == " << y.count() << endl;
    return 0;
}

/* Output:
x == {0,1,2,3,4,5,6,7,8,9}
y == {1,3,5,7,9}
y <= x? 1
y >= x? 0
x - y == {0,2,4,6,8}
x + y == {0,1,2,3,4,5,6,7,8,9}
x * y == {1,3,5,7,9}
~x == {10,11,12,13,14,15}
x.contains(2)? 1
y.contains(2)? 0
x.count() == 10
y.count() == 5
*/

// End of File

