// SFLOAT.CPP, Listing 3

#include <sfloat.hpp>

// Work space
unsigned short sfloat::Exp;
unsigned short sfloat::Man;

// Bit masks to extract parts of ieee float
unsigned long sfloat::fManSignMask = 0x80000000L;
unsigned long sfloat::fExpMask = 0x7F800000L;
unsigned long sfloat::fManMask = 0x007FFFFFL;

// Bit mask to extract parts of short float
unsigned short sfloat::sfManSignMask = 0x8000;

// float exponent bias
unsigned short sfloat::fBias = 127;

// short float exponent bias
unsigned short sfloat::sfBias = 127;

// fBias - sfBias
unsigned short sfloat::fsfBias = 0;

// if signed flag
unsigned short sfloat::Signed = 1;

// number of float exponent bits
unsigned short sfloat::fExpBits = 8;

// number of short float exponent bits
unsigned short sfloat::sfExpBits = 8;

// number of float mantissa bits
unsigned short sfloat::fManBits = 23;

// number of short float mantiss bits
unsigned short sfloat::sfManBits = 7;

// number of float mantissa sign bits
unsigned short sfloat::fManSignBits = 1;

// number of float mantissa sign bits
unsigned short sfloat::sfManSignBits = 1;

// number of short float bits
unsigned short sfloat::sfBits = 16;

// float mantissa shift
unsigned short sfloat::fManShift1 = 9;

// float mantissa shift
unsigned short sfloat::fManShift2 = 7;

// short float mantissa shift
unsigned short sfloat::sfManShift = 16;

// float exponent shift
unsigned short sfloat::fExpShift = 8;

// short float exponent shift
unsigned short sfloat::sfExpShift = 8;

// short float exponent minimum bits
unsigned short sfloat::sfExpBitsMin = 1;

// short float exponent maximum bits
unsigned short sfloat::sfExpBitsMax = 8;

// union for conversion
union conv sfloat::u;

void sfloatrange( unsigned short sfNumExpBits,
      unsigned short sfSigned )
   {

   // Set the number of short float exponent bits
   sfloat::sfExpBits = sfNumExpBits;
   if ( sfloat::sfExpBits > sfloat::sfExpBitsMax )
      {
      sfloat::sfExpBits = sfloat::sfExpBitsMax;
      }
   else if ( sfloat::sfExpBits <
         sfloat::sfExpBitsMin )
      {
      sfloat::sfExpBits = sfloat::sfExpBitsMin;
      }

   // Set the number of short float sign bits
   if ( sfSigned )
      {
      sfloat::Signed = sfloat::sfManSignBits = 1;
      }
   else
      {
      sfloat::Signed = sfloat::sfManSignBits = 0;
      }

   // Set the number of short float mantissa bits
   sfloat::sfManBits = sfloat::sfBits - 
         sfloat::sfManSignBits - sfloat::sfExpBits;

   // Set the short float exponent bias value
   sfloat::sfBias = 0;
   sfloat::sfBias =
         ( 1 << ( sfloat::sfExpBits - 1 )) - 1;
   sfloat::fsfBias = sfloat::fBias - sfloat::sfBias;

   // Set the converson shift values
   sfloat::fManShift1 = sfloat::sfManSignBits +
         sfloat::sfExpBits;
   sfloat::fManShift2 = sfloat::sfBits - 
         sfloat::fExpBits - sfloat::fManSignBits;
   sfloat::sfManShift = sfloat::fManBits -
         sfloat::sfBits + sfloat::sfExpBits +
         sfloat::sfManSignBits;
   sfloat::fExpShift = sfloat::sfManBits +
         sfloat::sfManSignBits;
   sfloat::sfExpShift = sfloat::sfBits -
         sfloat::sfExpBits;

   }   // sfloatrange

// End SFLOAT.CPP
