// SFLOAT.HPP, Listing 1

#if !defined ( SFLOAT_DEFINED )
#define SFLOAT_DEFINED

union conv
   {
   float f;
   long l;
   unsigned short s[2];
   };

class sfloat
   {

private:
   // class data
   static unsigned long fManSignMask;
   static unsigned long fExpMask;
   static unsigned long fManMask;
   static unsigned short sfManSignMask;
   static unsigned short ManSign;
   static unsigned short Exp;
   static unsigned short Man;
   static unsigned short fBias;
   static unsigned short sfBias;
   static unsigned short fsfBias;
   static unsigned short Signed;
   static unsigned short fExpBits;
   static unsigned short sfExpBits;
   static unsigned short fManBits;
   static unsigned short sfManBits;
   static unsigned short fManSignBits;
   static unsigned short sfManSignBits;
   static unsigned short sfBits;
   static unsigned short fManShift1;
   static unsigned short fManShift2;
   static unsigned short sfManShift;
   static unsigned short fExpShift;
   static unsigned short sfExpShift;
   static unsigned short sfExpBitsMin;
   static unsigned short sfExpBitsMax;
   static union conv u;

protected:
   // object instance data
   unsigned short s;

public:
   // constructors
   sfloat();
   sfloat( float );
   sfloat( sfloat& sf );

   // conversion
   operator float();

   // member function assignment operators
   sfloat &operator+=( sfloat sf );
   sfloat &operator-=( sfloat sf );
   sfloat &operator*=( sfloat sf );
   sfloat &operator/=( sfloat sf );

   // member function unary operators
   sfloat operator+();
   sfloat operator-();
   sfloat operator++();
   sfloat operator--();
   sfloat operator++( int );
   sfloat operator--( int );

   // friend function relational operators
   friend int operator==( sfloat sf1, sfloat sf2 );
   friend int operator>=( sfloat sf1, sfloat sf2 );
   friend int operator<=( sfloat sf1, sfloat sf2 );
   friend int operator>( sfloat sf1, sfloat sf2 );
   friend int operator<( sfloat sf1, sfloat sf2 );
   friend int operator!=( sfloat sf1, sfloat sf2 );

   // utility function
   friend void sfloatrange(
         unsigned short sfNumExpBits,
         unsigned short sfSigned );

   };   // class sfloat

// non-member function math operators
sfloat operator+( sfloat sf1, sfloat sf2 );
sfloat operator-( sfloat sf1, sfloat sf2 );
sfloat operator*( sfloat sf1, sfloat sf2 );
sfloat operator/( sfloat sf1, sfloat sf2 );

#include <sfloat.inl>

#endif

// End of SFLOAT.HPP
