// SFLOAT.INL, Listing 2

inline sfloat::sfloat() {}

inline sfloat::sfloat( float f )
   {

   // Init conversion union
   u.f = f;

   // Get the sign
   if ( Signed )
      {
      if ( !fsfBias )
         {
         s = u.s[1];
         return;
         }
      s = (unsigned short)
            (( u.l & fManSignMask ) >> sfBits );
      }
   else
      {
      s = 0;
      }

   // Get the exponent
   Exp = (unsigned short)
         (( u.l & fExpMask ) >> fManBits ) -
         fsfBias;

   // Compress the exponent
   Exp = ( Exp << ( sfExpShift )) >> sfManSignBits;

   // Get the mantissa
   Man = (unsigned short)(( u.l & fManMask ) >>
         ( sfManShift ));

   s |= Man | Exp;

   }   // sfloat( float )

inline sfloat::sfloat( sfloat& sf ) : s( sf.s ) {}

// Cast - conversion operators
inline sfloat::operator float()
   {

   // Get the sign - Init conversion union
   if ( Signed )

      {
      if ( !fsfBias )
         {j      ܌         u.s[0] = 0;
         u.s[1] = s;
         return ( u.f );
         }
      u.l = ( (unsigned long)
            (s & sfManSignMask )) << sfBits;
      }
   else
      {
      u.l = 0L;
      }

   // Get exponent
   u.l |= (unsigned long)((( s << sfManSignBits ) >>
         fExpShift ) + fsfBias ) << fManBits;

   // Get the mantisa
   u.l |= ( (unsigned long)( s << fManShift1 )) <<
         fManShift2;

   return ( u.f );

   }   // operator(float)

// Overloaded operators

// Assigment operators
inline sfloat &sfloat::operator+=( sfloat sf )
   {
   float f = (float)*this;
   f += (float)sf;
   *this = (sfloat)f;
   return ( *this );
   }   // operator+=

inline sfloat &sfloat::operator-=( sfloat sf )
   {
   float f = (float)*this;
   f -= (float)sf;
   *this = (sfloat)f;
   return ( *this );
   }   // operator-=

inline sfloat &sfloat::operator*=( sfloat sf )
   {
   float f = (float)*this;
   f *= (float)sf;
   *this = (sfloat)f;
   return ( *this );
   }   // operator*=

inline sfloat &sfloat::operator/=( sfloat sf )
   {
   float f = (float)*this;j      ܌   f /= (float)sf;
   *this = (sfloat)f;
   return ( *this );
   }   // operator/=

// increment operators
inline sfloat sfloat::operator++()
   { return ( *this += 1.0f ); }

inline sfloat sfloat::operator--()
   { return ( *this -= 1.0f ); }

inline sfloat sfloat::operator++( int )
   {
   sfloat sf( *this );
   *this += 1.0f;
   return ( sf );
   }   // operator ++

inline sfloat sfloat::operator--(int )
   {
   sfloat sf( *this );
   *this -= 1.0f;
   return ( sf );
   }   // operator --

// sign change operators
inline sfloat sfloat::operator+()
   { return ( *this ); }

inline sfloat sfloat::operator-()
   {
   sfloat sf( 0.0f );
   return ( sf - *this );
   }   // operator -

// Logical operators
inline int operator==( sfloat sf1, sfloat sf2 )
   { return ( sf1.s == sf2.s ); }

inline int operator<=( sfloat sf1, sfloat sf2 )
   { return ( sf1.s <= sf2.s ); }

inline int operator>=( sfloat sf1, sfloat sf2 )
   { return ( sf1.s >= sf2.s ); }

inline int operator<( sfloat sf1, sfloat sf2 )
   { return ( sf1.s < sf2.s  ); }

inline int operator>( sfloat sf1, sfloat sf2 )
   { return ( sf1.s > sf2.s ); }

inline int operator!=( sfloat sf1, sfloat sf2 )
   { return ( !( sf1.s == sf2.s )); }j      ܌
// math operations
inline sfloat operator+( sfloat sf1, sfloat sf2 )
   { return ( sf1 += sf2 ); }

inline sfloat operator-( sfloat sf1, sfloat sf2 )
   { return ( sf1 -= sf2 ); }

inline sfloat operator*( sfloat sf1, sfloat sf2 )
   { return ( sf1 *= sf2 ); }

inline sfloat operator/( sfloat sf1, sfloat sf2 )
   { return ( sf1 /= sf2 ); }

// End of SFLOAT.INL
