#ifndef __CSCHLR
#define __CSHLR

#include <time.h>
#include "cthread.hpp"
#include "csemq.hpp"

struct schlr_table
  {
  time_t wakeuptime;
  int next;
  };

class Cschlr
{
private:
  Csemq readyQ;				//ready-to-run queue
  Csemq waitQ;				//queue for delayed threads to wait on
  Cthread *task[CSC_NO_THREAD + 3];	//thread objects
  schlr_table *table;			//delay table (linked list)
  int head;				//head of linked list
  int nTask;				//number of threads created
  int nRunning;				//running thread number

  void Switch(Csemq *sem);
  void WakeUp();
  

public:
  Cschlr();
  ~Cschlr();
  int CreateThread(THDFN func, int stacksize, void *param);
  void Suicide();
  Csemq* CreateSem(long lValue);
  void DestroySem(Csemq *sem);
  void Signal(Csemq *sem, long lMaxCount = 256);
  void Wait(Csemq *sem);
  void Preempt();
  void Sleep(long lSeconds);
  void GetSemStates(Csemq *sem, long &lCount, int &fWait);
  void Run();
  
};

#endif
