#ifndef	__CTHREAD
#define __CTHREAD

#include <setjmp.h>

const int THD_MAX_STACK = 0x4000;	/* maximum stack size allowed */

typedef void (* THDFN)(void);

typedef struct thd_type {
  jmp_buf Context;		/* context of thread */
  int TotalLen;			/* total length of structure */
  int Overflowed;		/* overflow guard */
  int Stack[THD_MAX_STACK];	/* stack of thread */
  } THD, *THDPTR;


class Cthread
{
private:

  THDPTR threadbody;
  

  Cthread(THDFN func, int stacksize, int *frame, int framesize);

  void Transfer(Cthread& thread);
  
  ~Cthread(void); 

  friend Cschlr;

};

#endif
