LISTING 5 - Derives Exception Classes from the Standard Exception
Hierarchy

// ddir3.cpp
#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <string.h>
#include <sys/stat.h>
#include <dirent.h>
#include <dir.h>
#include <iostream.h>
#include <fstream.h>
#include <strstream.h>
#include <cstring.h>
#include <except.h>

// Exception classes
class Dir_err : public runtime
{
public:
    Dir_err(const string& s) : runtime(s){}
};

class Bad_dir : public Dir_err
{
public:
    Bad_dir(const string& s) : Dir_err(s){}
};

class Dir_open_err : public Dir_err
{
public:
    Dir_open_err(const string& s) : Dir_err(s){}
};

class File_del_err : public Dir_err
{
public:
    File_del_err(const string& s) : Dir_err(s){}
};

class Dir_del_err : public Dir_err
{
public:
    Dir_del_err(const string& s) : Dir_err(s){}
};

// Put response file in root directory
char response_file[L_tmpnam+1] = "\\";
// (Change this to "/" for UNIX)


main(int argc, char **argv)
{
    char *old_path = getcwd(NULL,MAXDIR);
    void rd(char *);

    // Initialize response file for DOS "del" command
    tmpnam(response_file+1);
    ofstream(response_file) << "Y\n";

    // Delete the directories
    while (--argc)
    {
        try
        {
            rd(*++argv);
        }

        // Catch exceptions
        catch(const Bad_dir& x)
        {
            cerr << "Invalid directory: "
                 << x.what() << endl;
        }
        catch(const Dir_open_err& x)
        {
            cerr << "Error opening directory: "
                 << x.what() << endl;
        }
        catch(const File_del_err& x)
        {
            cerr << "Error deleting file: "
                 << x.what() << endl;
        }
        catch(const Dir_del_err& x)
        {
            cerr << "Error deleting directory: "
                 << x.what() << endl;
        }
        catch(const Dir_err& x)
        {
            cerr << "Directory error: "
                 << x.what() << endl;
        }
    }

    // Clean-up
    remove(response_file);
    chdir(old_path);
    return 0;
}

void rd(char* dir)
{
    // Log onto the directory that is to be deleted
    if (chdir(dir))
        throw Bad_dir(dir);
    cout << strlwr(dir) << endl;

    // Delete all normal files via OS shell
    const size_t SH_CMD_LEN = 14;
    char sh_cmd[L_tmpnam+SH_CMD_LEN+1];
    ostrstream(sh_cmd,sizeof sh_cmd) << "del *.* <"
                                     << response_file
                                     << " >nul"
                                     << ends;
    system(sh_cmd);

    // Delete any remaining directory entries
    DIR *dirp;
    struct dirent *entry;
    if ((dirp = opendir(".")) == NULL)
        throw Dir_open_err(dir);
    while ((entry = readdir(dirp)) != NULL)
    {
        struct stat finfo;

        if (entry->d_name[0] == '.')
            continue;
        stat(entry->d_name,&finfo);
        if (finfo.st_mode & S_IFDIR)
            rd(entry->d_name);      // Subdirectory
        else
        {
            // Enable delete of file, then do it
            chmod(entry->d_name,S_IWRITE);
            if (unlink(entry->d_name))
                throw File_del_err(entry->d_name);
        }
    }
    closedir(dirp);

    // Remove the directory from its parent
    chdir("..");
    if (rmdir(dir))
        throw Dir_del_err(dir);
}

