LISTING 1 - Illustrates objects left undestroyed by longjmp

// destroy1.cpp
#include <iostream.h>
#include <setjmp.h>

class Foo
{
public:
    Foo() {cout << "Foo constructor" << endl;}
    ~Foo() {cout << "Foo destructor" << endl;}
};

void f();
void g();

jmp_buf env;

main()
{
    if (setjmp(env) == 0)
        f();
    else
        cout << "Returned via longjmp" << endl;
    return 0;
}

void f()
{
    Foo x;

    g();
}

void g()
{
    Foo x;

    longjmp(env,1);
}

/* Output:
Foo constructor
Foo constructor
Returned via longjmp
*/
