Listing 2: Classes that descend from Field

/* ========================================== */
/* Integer and String Field Implementations   */
/* ========================================== */

#define DEREF( field, type, data ) \
    (*(type *)&((char *)data)[ field->getOffset() ])

class IntField : public Field {
    int &deRef( void *data ) {
        return DEREF( this, int, data );
    }
public:
    IntField( char *name, int offset )
        :Field( name, offset ) {}

    const char *getTypeName () { return "int"; }

    char *toString( char *string, void *data ) {
        sprintf( string, "%d", deRef( data ) );
        return string;
    }

    void fromString( void *data, char *string ) {
        deRef( data ) = atoi( string );
    }

    void assign( void *dest, void *srce ) {
        deRef( dest ) = deRef( srce );
    }

    int compare( void *lhs, void *rhs ) {
        return deRef( lhs ) - deRef( rhs );
    }
} ;


class CharField : public Field {
    char* &deRef( void *data ) {
        return DEREF( this, char*, data );
    }
public:
    CharField( char *name, int offset )
        :Field( name, offset ) {}

    const char *getTypeName () { return "char*"; }

    char *toString( char *string, void *data ) {
        return strcpy( string, deRef( data ) );
    }

    void fromString( void *data, char *string ) {
        strcpy( deRef( data ), string );
    }

    void assign( void *dest, void *srce ) {
        strcpy( deRef( dest ), deRef( srce ) );
    }

    int compare( void *lhs, void *rhs ) {
        return strcmp( deRef( lhs ), deRef( rhs ) );
    }
} ;
