Listing 4: Declaration for Mapped Object

class MappedObject {
protected:
    Map &map;
public:
    virtual ~MappedObject() {}
    MappedObject( Map &map ) : map( map ) {}
    MappedObject( MappedObject &object );

    friend ostream &operator << ( ostream &o, MappedObject &object );
    friend istream &operator >> ( istream &i, MappedObject &object );

    int  compare ( MappedObject &object );
    void assign  ( MappedObject &object );
    void print   ();

    int operator == ( MappedObject &o ) { return compare( o ) == 0; }
    int operator != ( MappedObject &o ) { return compare( o ) != 0; }
    int operator >= ( MappedObject &o ) { return compare( o ) >= 0; }
    int operator >  ( MappedObject &o ) { return compare( o ) >  0; }
    int operator <= ( MappedObject &o ) { return compare( o ) <= 0; }
    int operator <  ( MappedObject &o ) { return compare( o ) <  0; }
} ;
