Listing 5: Mapped object stream operators

ostream &operator << ( ostream &o, MappedObject &object )
{
    char buf[ 256 ];
    Map &map = object.map;

    o << map.getName() << " ";

    for (int i = 0; i < map.getCount(); ++i)
        o << map[ i ].toString( buf, &object ) << " ";

    return o;
}

istream &operator >> ( istream &i, MappedObject &object )
{
    char buf[ 256 ];
    Map &map = object.map;

    i >> buf;

    if (strcmp( buf, map.getName() )) {
        printf( "Cannot convert <%s> to <%s> in operator >>\n",
                 buf, map.getName() );
        exit( -1 );
    }

    for (int k = 0; k < map.getCount(); ++k)
        i >> buf, map[ k ].fromString( &object, buf );

    return i;
}
