Listing 6: Implementation of a Point Mapped object

class Point : public MappedObject {
    int x, y;
    char *text;
    static Map map;
    static Field *fieldv[];
public:
    Point();
    Point( int x, int y, char *text );
} ;

Field *Point::fieldv[] = {
    new IntField  ( "x",    offsetof( Point, x ) ),
    new IntField  ( "y",    offsetof( Point, y ) ),
    new CharField ( "text", offsetof( Point, text ) ),
} ;

Map Point::map( "Point", fieldv, sizeof(Point::fieldv) / sizeof(Point*) );

Point::Point()
      :MappedObject( map ), x( 0 ), y( 0 ), text( "" )
{
}

Point::Point( int x, int y, char *text )
      :MappedObject( map ), x( x ), y( y ), text( text )
{
}
