/*-------------------------------Defines----------------------------------------*/

#define EQ    ==        /* comparison for equality.      */
#define NEQ   !=        /* comparison for non equality.  */
#define AND   &&        /* logical and.                  */
#define OR    ||        /* logical or.                   */

enum E_BOOL    {TRUE, FALSE};

/*--------------------------- STORAGE CLASSES  ---------------------------------*/

#define EXPORT                       /* definition of global variables */
                                     /* and functions used also by     */
                                     /* other modules.                 */

#define IMPORT extern                /* reference to global variables  */
                                     /* and functions, defined by      */
                                     /* another module.                */

#define LOCAL static                 /* reference to global variables  */
                                     /* and functions, defined and     */
                                     /* used by actual module.         */

/*----------------------------Typedefs-------------------------------------------*/
/*----(are valid for most processors and compilers. If not, change typedefs------*/
/*-----so that LONG, ULONG, SHORT, USHORT, CHAR and UCHAR are in the proper------*/
/*-----range)--------------------------------------------------------------------*/

typedef signed long    LONG;            /* range: -2**31 ... 2**31-1*/
typedef unsigned long  ULONG;           /* range:      0 ... 2**32-1*/

typedef signed short   SHORT;           /* range: -32768 ... +32767 */
typedef unsigned short USHORT;          /* range:      0 ... +65535 */

typedef signed char    CHAR;            /* range:   -128 ... +127   */
typedef unsigned char  UCHAR;           /* range:      0 ... +255   */

typedef unsigned int   BITFIELD;        /* range: CPU-dependent     */



