#ifndef _STDTYP
/***C*H***************************************************************
**                                                                  **
** SRC-MODULE   : stdtyp.h                                          **
** VERSION      : 0102                                              **
** LONG_NAME    : declaration of STandarD TYPes                     **
**                                                                  **
**                                                                  **
** SP_NO        :                                                   **
** SUBSYSTEM    : all subsystems                                    **
** SYSTEM_TYPE  : 486 PC                                            **
**                                                                  **
** AUTHOR       : Maucher, ZFE ST ACK 21, 44031                     **
** SUBSTITUTE   : Storn,   ZFE ST ACK 21, 40502                     **
**                                                                  **
** DESCRIPTION  : To guarantee a high portability of C programs,    **
**                standard C types shall not be used, because they  **
**                can represent a different number of bytes on      **
**                different processors.                             **
**                The following types, which have to be adapted to  **
**                each processor (and C-compiler), shall be used.   **
**                                                                  **
**                Some additional definitions concern boolean values**
**                and storage classes.                              **
**                                                                  **
** REMARKS      : This header file works with Microsoft C 6.0.      **
**                                                                  **
** COPYRIGHT    : (c) Copyright Siemens AG, 1993                    **
**                                                                  **
***C*H*E**************************************************************/

/***H*O*C*************************************************************
**                                                                  **
** No.!Version! Date ! Request !     Modifikation          ! Author **
** ---+-------+------+---------+---------------------------+------- **
**    !       !190990!         ! first creation            ! Mau    **
**    !       !      !         !                           !        **
**  1 ! 0101  !150191! REVIEW  ! remove #ifndef, add LOCAL,! pjk    **
**    !       !      !         ! add NEQ, change some type-!        **
**    !       !      !         ! defs                      !        **
**  2 ! 0102  !140391! REVIEW  ! typedefs                  ! voi    **
**    !       !      !         !                           !        **
**    !       !      !         !                           !        **
**                                                                  **
***H*O*C*E***********************************************************/

/*---------------Defines--------------------------------------------*/

#define EQ     ==               /* Comparison for equality        */
#define NEQ    !=               /* Comparison for non equality    */
#define AND    &&               /* logical and                    */
#define OR     ||               /* logical or                     */

#define TRUE   1                /* boolean value true             */
#define FALSE  0                /* bollean value false            */
#define BOOL   int              /* Type Bool                      */

/*---------------Macros---------------------------------------------*/

#define init_pointer(x,y)  ((x)=(y))  /* pointer initialization   */

/*---------------STORAGE CLASSES------------------------------------*/

#define EXPORT                  /* definition of global variables */
                                /* and functions used also by     */
                                /* other modules.                 */

#define IMPORT extern           /* reference to global variables  */
                                /* and functions, defined by      */
                                /* another module.                */

#define LOCAL static            /* reference to global variables  */
                                /* and functions, defined and     */
                                /* used by actual module.         */

/*---------------Typedefs--------------------------------------------*/

typedef signed long    LONG;   /* 32bit *//* range: -2**31 ... 2**31-1*/
typedef unsigned long  ULONG;             /* range:      0 ... 2**32-1*/

typedef signed int     SHORT;  /* 16bit *//* range: -32768 ... +32767 */
typedef unsigned int   USHORT;            /* range:      0 ... +65535 */

typedef signed char    CHAR;   /*  8bit *//* range:   -128 ... +127   */
typedef unsigned char  UCHAR;             /* range:      0 ... +255   */

typedef unsigned int   BITFIELD;          /* range: CPU-dependent     */

#define _STDTYP
#endif
