/* File:  convutil.h
   Description: Header file for support code
    for the conversion program.
*/
#ifndef CONVUTIL_H
#define CONVUTIL_H
#include <string.h>
/* == miscellaneous types and functions ========== */
typedef enum { FALSE, TRUE} BOOLEAN;
/* ---- enumeration of attribute types ----------- */
enum ATTTYPE {
   NAME,
   FILEN,
   LINE,
   UNKNOWN
};
char * makeHeap(char * s);
                          /* copy string s to heap */
BOOLEAN setErrorFile(char * fname);
                /* set name of error file to fname */
void wrError(int line, int column);
            /* write message error at line, column */
void cleanUp();
                /* free the current attribute list */
void putInstanceVariable(void);
    /* write Prolog facts for an instance variable */
void putClass(void);
                 /* write Prolog facts for a class */
/* == Attribute class and derived classes =========*/
class Attribute {
protected:
   enum ATTTYPE atType;
                     /* the type of this attribute */
public:
   virtual char * asString(void) = 0;
  /* answer a ptr to a string rep of the attribute */
   void setType(enum ATTTYPE aT) {atType = aT;}
   virtual ~Attribute() {};
};
class StringAttribute : public Attribute {
         /* An Attribute whose value is a C string */
   char * str;
public:
   StringAttribute( char * s)
         { atType = UNKNOWN; str = s;}
   ~StringAttribute() { delete str;}
   virtual char * asString(void) { return str;}
};
class IdAttribute : public Attribute {
   /* An Attribute with 2 parts, eg:               */
   /*   foo::fob::fab::xxxyyzzzz (int *) const     */
   /*   <---scoped name ------->|<-- remainder --> */
   /* The str holds the whole thing.               */
   char * str;
   char * scopedName;
public:
   IdAttribute(char * sname, char * remainder);
       /* construct from scoped name and remainder */
   ~IdAttribute() {
       delete str; delete scopedName;
       }
   char * asString(void) { return str;}
   char * scopedNamePart(void) {return scopedName;}
};
/* = buffer for reading strings, etc. ============ */
#define MAXCOLLECT 10000         /* size of buffer */
void collect(char c);    /* add c to end of buffer */
void collectFirst(char c);
                         /* clear buffer and add c */
char * release();
        /* copy buffer to heap and return the copy */

/* ===== simple linked list of attributes ======== */
struct ATTLIST {
    enum ATTTYPE attype;
    Attribute * attrib;            
    struct ATTLIST * next;
};
struct ATTLIST * listAdd(struct ATTLIST * aList,
              enum ATTTYPE aType, Attribute * aData);
struct ATTLIST * listFind(struct ATTLIST * aList,
                               enum ATTTYPE aType);
int listSize(struct ATTLIST *aList);
void listFree(struct ATTLIST *aList);

/* == Functions for the global AttribList ======= */
void atAdd(enum ATTTYPE aType, Attribute * aData);
#endif