Listing 4 - class definition for a variable-length string

//
// str.h - a variable-length string (interface)
//

#include <iostream.h>
#include <string.h>

class str
	{
	friend ostream &
		operator<<(ostream &, const str &);
	friend istream &
		operator>>(istream &, str &);
public:
	str(const char * = "");
	str(const str &);
	~str();
	const str &operator=(const char *);
	const str &operator=(const str &);
	size_t length();
private:
	size_t len;
	char *ptr;
	};

inline str::~str()
	{
	delete [] ptr;
	}

inline size_t str::length()
	{
	return len;
	}

