Listing 4
    NAME    ROMSTART_TEXT
;
; example startup code for
; imbedded systems use
;
; segment classes
; High addrs (rom)
; 'BOOT'
;  ""
;  ""
; 'CODE'      _TEXT segment
;
; ram
;
; 'STACK'    UDATA_END segment
; 'BSS'      IDATA_END and UDATA_BEG segments
; 'CONST'
; 'DATA'     IDATA_BEG segment
; 
; Rename object file output to c0x.obj
; where x = S,C,M,L, or H
; and locate in project subdirectory
;  Memory model selection set to 1 all others 0
;
SMALLM	EQU 0
COMPACTM EQU 0
MEDIUMM	EQU 0
LARGEM	EQU 1
HUGEM	EQU 0

STACK_SIZE  EQU 1000H	;set desired stack size
__acrtused  equ 1       ;satisfy external reference

    PUBLIC  __acrtused

DGROUP GROUP IDATA_BEG, _DATA, CONST, IDATA_END,\
		  UDATA_BEG, _BSS, STACK, UDATA_END
; this segment marks beginning of rom code
ROMSTART_BEG SEGMENT BYTE 'CODE'
ROMSTART_BEG ENDS

IF SMALLM OR COMPACTM
_TEXT SEGMENT BYTE PUBLIC 'CODE'
    EXTRN   _main:NEAR	    ;main program
ASSUME CS:_TEXT

ENDIF
IF MEDIUMM OR LARGEM OR HUGEM
    EXTRN  _main:FAR  ;main c program
_TEXT SEGMENT BYTE PUBLIC 'CODE'
    ASSUME CS:_TEXT
ENDIF

    ASSUME DS:DGROUP, SS:DGROUP
    PUBLIC start

start	PROC  NEAR
    cli
    cld
;********************************************
;
;   do hardware initialization and ram check
;
;********************************************

    PUBLIC  init_ram

init_ram:
;**********
; transfer initialize data from rom to ram
;
    MOV BX, SEG IDATA_BEG
    MOV AX, SEG IDATA_END    ;data to init.
    sub ax,bx
    mov cl,3
    shl ax,cl
    mov cx,ax
    jcxz    no_init_data

;address of frame # in rom
    mov ax, seg ENDCODE   ;needed for jbromldr
    inc ax       ;ram init values begin at
    mov ds,ax    ;segment ENDCODE + 1     
    mov si,0
;address of frame # in ram
    mov ax, seg IDATA_BEG
    mov es,ax
    mov di,0
; initialize data and const segments
rep movsw   ;word transfer
no_init_data:    
    mov bx, seg UDATA_BEG  ;clear bss data
    mov ax, seg UDATA_END
    sub ax, bx
    mov cl,3
    shl ax,cl
    mov cx,ax
    jcxz no_zerodata
    mov es,bx
    mov di,0
    mov ax,0
rep stosw
    PUBLIC  no_zerodata
no_zerodata:
    mov ax,DGROUP  ; set up stack
    mov ds,ax
    mov ss,ax
    mov sp,OFFSET DGROUP:STACK_TOP
;*********************************************
;  add code to:
;   1) initialize INITDATA Functions (see c0.asm)
;   2) capture interrupt vectors 0-4
;*********************************************
    sti 	;enable interrupts
    call _main	;enter main program
;*********************************************
;  add code to:
;   1) shut down EXITDATA Functions
;   2) handle shutdown errors
;   3) prepare to restart
;*********************************************
    jmp start
start ENDP
_abort          PROC    DIST
		PUBLIC  _abort
;handle error abort
    jmp start
_abort ENDP
IF SMALLM OR COMPACTM
_TEXT ENDS 
ENDIF
IF MEDIUMM OR LARGEM OR HUGEM
_TEXT ENDS
ENDIF

; segment marks end of rom code
;make it non zero, length < 16 bytes 
ENDCODE SEGMENT PARA PUBLIC 'ENDCODE'
       db  "ENDROM"   ;seg ENDCODE+1 = begin ram
ENDCODE ENDS
;*********************************

;beginning of dgroup and initialized data in ram

IDATA_BEG   SEGMENT PARA PUBLIC 'IDATA_BEG'
IDATA_BEG   ENDS

_FARDATA    SEGMENT PARA PUBLIC 'FAR_DATA'
_FARDATA    ENDS

_DATA	SEGMENT PARA PUBLIC 'DATA'
_DATA	ENDS

_CVTSEG SEGMENT WORD PUBLIC 'DATA'
  PUBLIC __RealCvtVector
__RealCvtVector label word
_CVTSEG	ENDS
_SCNSEG	SEGMENT WORD PUBLIC 'DATA'
_SCNSEG	ENDS

CONST	SEGMENT WORD PUBLIC 'CONST'
CONST	ENDS

_INIT_	SEGMENT WORD PUBLIC 'INITDATA'
_INIT_  ENDS
_INITEND_ SEGMENT WORD PUBLIC 'INITDATA'
_INITEND_ ENDS

_EXIT_  SEGMENT WORD PUBLIC 'EXITDATA'
_EXIT_  ENDS

_EXITEND_ SEGMENT WORD PUBLIC 'EXITDATA'
_EXITEND_ ENDS

IDATA_END SEGMENT PARA PUBLIC 'IDATA_END'
IDATA_END ENDS

; end of initialized data

UDATA_BEG SEGMENT WORD PUBLIC 'UDATA_BEG'
UDATA_BEG ENDS

_BSS	SEGMENT WORD PUBLIC 'BSS'
_BSS	ENDS 
_BSSEND	SEGMENT BYTE PUBLIC 'BSSEND'
_BSSEND	ENDS

STACK	SEGMENT PARA STACK 'STACK'
    DW	STACK_SIZE DUP (?)

STACK_TOP   LABEL WORD
STACK	ENDS

; end of initialized segment in ram
UDATA_END SEGMENT WORD PUBLIC 'UDATA_END'
UDATA_END   ENDS
; bootstrap address for powerup reset
; far jump to program beginning
; may have to be manually placed in EPROM
;BOOTSTRAP   SEGMENT AT 0FFFFH
;	JMP FAR PTR start
;
;BOOTSTRAP ENDS
	end start

