#include "mempool.h"
#include <fstream.h>
#include <string.h>
              
class Link {
  char *data;
  Link *next;
  static MemoryPool pool;
public:
  friend class List;
  friend class Iterator;
  Link(const char *_data, 
    Link *_next) 
  { 
    next = _next; 
    data = strcpy(new 
      char[strlen(_data)+1],
      _data); 
  }
  ~Link() 
  { 
    delete data; 
  }
  void *
    operator new(size_t) 
  { 
    return pool.malloc(); 
  }
  void 
    operator delete(void *ptr) 
  { 
    pool.free(ptr); 
  }
};
              
MemoryPool 
Link::pool(sizeof(Link));
              
class List {
  Link head;
public:
  friend class Iterator;
  List ();
  ~List();
  void add(char *data);
};
              
class Iterator {
  Link *link;
public:
  Iterator(List &_list) 
  { 
    link = _list.head.next; 
  }
  char *Next() 
  { 
    char *ret = link ? 
      link->data : NULL; 
    link = link->next; 
    return ret;
  }
};
              
List::List()
  : head("",NULL)
{
  ;
}
              
List::~List()
{
  while(head.next)
  {
    Link *temp = 
      head.next->next;
    delete head.next;
    head.next = temp;
  }
}

void List::add(char *data)
{
  head.next = new 
    Link(data,head.next);
}
              
main(int, char **argv)
{
static char buff[1024];
  List list;
  ifstream in(argv[1]);
  while(in.getline(buff,
    sizeof(buff)))
    list.add(buff);
  Iterator it(list);
  char *ptr;
  while((ptr = it.Next()) != 
    NULL)
    cout << ptr << endl;
}
