// listing 1.

#ifndef MEMPOOL_H
#define MEMPOOL_H

#include <stddef.h>

const CharSize = 8;
const PoolSize = 
  sizeof(unsigned long)*CharSize;

class MemoryPoolLink {
private:
friend class MemoryPool;
  MemoryPoolLink(size_t _size, 
    MemoryPoolLink *_next);
  ~MemoryPoolLink();
  void *malloc(size_t size);
  void free(void *, size_t size);
  unsigned long bits;
  MemoryPoolLink *next;
  char *data;
};

class MemoryPool {
  MemoryPoolLink freeHead;
  MemoryPoolLink usedHead;
  size_t size;
public:
  MemoryPool(size_t size);
  void *add();
  void *malloc();
  void free(void *);
};

#endif
