class String {
private:
  struct StringImp {
    char *ptr;  
    unsigned count;
    StringImp(const char *str) 
      : ptr(strdup(str)), 
        count(1) 
    { 
      ; 
    }
    ~StringImp() 
    { 
      delete[] ptr; 
    }
  } *imp;
public:
  String(const char *str) 
  { 
    imp = new StringImp(str); 
  }
  String(const String &str) 
  { 
    imp = str.imp; 
    imp->count++; 
  }
// assignment is a little tricky
  String &
  operator=(const String &str) 
  {
// increment first in case 
// of assignment to self
    str.imp->count++;  
// be sure to clean up the old imp!
    if(--imp->count == 0) 
      delete imp;       
    imp = str.imp;
    return *this;
  }
  ~String() 
  { 
    if(--imp->count == 0) 
      delete imp; 
  }
};


