Listing 1 - a class hierarchy with virtual cloning functions that have 
identical return type

//
// base class 'shape'
//
class shape
    {
public:
    enum palette { BLUE, GREEN, RED };
    shape(palette c);
    virtual double area() const = 0;
    virtual shape *clone() const = 0;
    palette color() const;
    virtual const char *name() const = 0;
    virtual ostream &put(ostream &os) const;
private:
    palette _color;
    static const char *color_image[RED - BLUE + 1];
    };

...

//
// class 'circle' derived from 'shape'
//
class circle : public shape
    {
public:
    circle(palette c, double r);
    double area() const;
    shape *clone() const;
    const char *name() const;
    ostream &put(ostream &os) const;
private:
    double radius;
    };

shape *circle::clone() const
    {
    return new circle(*this);
    }

...

//
// class 'rectangle' derived from 'shape'
//
class rectangle : public shape
    {
public:
    rectangle(palette c, double h, double w);
    double area() const;
    shape *clone() const;
    const char *name() const;
    ostream &put(ostream &os) const;
private:
    double height, width;
    };

shape *rectangle::clone() const
    {
    return new rectangle(*this);
    }

...

//
// class 'triangle' derived from 'shape'
//
class triangle : public shape
    {
public:
    triangle(palette c, double s1, double s2, double a);
    double area() const;
    shape *clone() const;
    const char *name() const;
    ostream &put(ostream &os) const;
private:
    double side1, side2, angle;
    };

shape *triangle::clone() const
    {
    return new triangle(*this);
    }

...
