
Listing 2.  Vector with dynamic VES and reference counting 

class Vector;
class VES                // VES class definition
{    unsigned lng;            // Vector Length
     unsigned refs;           // Reference Count
     double *ves;             // VES
     friend Vector;
     VES ()                   // Default Constructor
     {    lng = 0;            // No VES
          refs = 0;
          ves = NULL; }
     VES (const unsigned ln)       // New Vector VES Constructor
     {    lng = ln;           // Set length
          ves = new double [ln];   // Allocate new VES
          refs = 0; }
     VES (const VES& v)       // Copy Constructor
     {    lng = v.lng;        // Set length
          ves = new double [lng];  // Allocate new VES & copy
          memcpy (ves, v.ves, lng * sizeof(double));
          refs = 0; }
     ~VES () { if (ves != NULL) delete ves; }          // VES Destructor
};
class Vector             // Vector class definition
{    VES *x;                  // Pointer to VES wrapper
    public:
     Vector () {    x = NULL; }         // Default Constructor
     Vector (const unsigned ln)    // New Vector Constructor
     {    x = new VES (ln); }      // Create a new VES
     Vector (const Vector& v) // Copy Constructor
     {    x = v.x;                 // Copy VES
          x->refs++; }             // Increment reference count
     ~Vector ()                    // Destructor
     {    x->refs--;                    // Decrement reference count
          if (x->refs == 0) delete x; } // If no references, delete
     double& operator()(const int coordinate) const
     {    // Address elements by coordinate
          return x->ves[coordinate]; }
     unsigned length() const { return x->lng; } // Report Vector length
     Vector& operator= (const Vector&);      // Assignment operator
     Vector operator+ (const Vector&) const; // Addition operator
     friend Vector unit (const Vector&);          // Unitize Vector
};
Vector& Vector::operator= (const Vector& v)  // Assignment operator
{    if (ves != v.ves) {      // Protect against self-reference
          if (x != NULL) {    // If current VES has no other references,
               if (--(x->refs) == 0) delete x; } // delete VES
          x = v.x; }          // Copy reference to VES
     return *this; }
Vector Vector::operator+ (const Vector& v)   // Vector addition
{    if (v.x->lng != x->lng) exit(1);   // Ensure conformal addition
     Vector u (x->lng);            // Create same size Vector
     for (int i = 0; i < x->lng; i++)   // Carry out addition
          u.x->ves[i] = x->ves[i] + v.x->ves[i];
     return u; }

