Listing 1.  Vector function unit 

Vector unit(const Vector& v)  // Unitize the input vector
{    Vector u(v.length());         // Create same size Vector
     int i;
     double sumsq = 0.0;
     for (i = 0; i < v.length; i++)   // Find sum of squares
          sumsq += v(i) * v(i);              
     if (sumsq != 0.0)   // Avoid divide by zero problems
          sumsq = 1 / sqrt (sumsq);
     for (i = 0; i < v.length(); i++) // Apply scaling
          u(i) = v(i) * sumsq; 
     return u;
}

