
LISTING 2 -
// date.h

// Forward declarations
class istream;
class ostream;

class Date
{
public:
    // Constructors
    Date();
    Date(int m, int d, int y);

    // Accessor Functions
    int month() const;
    int month(int);
    int day() const;
    int day(int);
    int year() const;
    int year(int);

    // Relational operators
    int operator<(const Date& d2) const;
    int operator<=(const Date& d2) const;
    int operator>(const Date& d2) const;
    int operator>=(const Date& d2) const;
    int operator==(const Date& d2) const;
    int operator!=(const Date& d2) const;

    // Stream I/O operators
    friend ostream& operator<<(ostream&, const Date&);
    friend istream& operator>>(istream&, Date&);

    static int isleap(int y);

private:
    int month_;
    int day_;
    int year_;

    static int dtab[2][13];
    static int compare(const Date&, const Date&);
};

inline int Date::month() const
{
    return month_;
}

inline int Date::day() const
{
    return day_;
}

inline int Date::year() const
{
    return year_;
}

inline Date::Date(int m, int d, int y)
{
    month_ = m;
    day_ = d;
    year_ = y;
}

inline int Date::isleap(int y)
{
    return y%4 == 0 && y%100 != 0 || y%400 == 0;
}

inline int Date::operator<(const Date& d2) const
{
    return compare(*this,d2) < 0;
}

inline int Date::operator>(const Date& d2) const
{
    return compare(*this,d2) > 0;
}

inline int Date::operator<=(const Date& d2) const
{
    return compare(*this,d2) <= 0;
}

inline int Date::operator>=(const Date& d2) const
{
    return compare(*this,d2) >= 0;
}

inline int Date::operator==(const Date& d2) const
{
    return compare(*this,d2) == 0;
}

inline int Date::operator!=(const Date& d2) const
{
    return compare(*this,d2) != 0;
}
