Listing 11 - lns as a concrete class with a single private pointer to a 
protocol-based implementation object

//
// lns4.h - line number sequence interface
//
#ifndef LNS_H_INCLUDED
#define LNS_H_INCLUDED

class lns
    {
public:
    lns(unsigned n);
    ~lns();
    void add(unsigned n);
    void print();
    struct protocol;
private:
    protocol *pp;
    };

struct lns::protocol
    {
    virtual ~protocol() = 0;
    virtual void add(unsigned n) = 0;
    virtual void print() = 0;
    };

inline lns::~lns()
    {
    delete pp;
    }

inline void lns::add(unsigned n)
    {
    pp->add(n);
    }

inline void lns::print()
    {
    pp->print();
    }

#endif

