Listing 1 - the main module for the cross-reference program

//
// xr.cpp - a cross-reference generator
//
#include <assert.h>
#include <ctype.h>
#include <stdio.h>

#include "xrt.h"

int getword(char *word, size_t lim)
    {
    int c;
    char *w = word;

    assert(lim > 2);
    while (isspace(c = fgetc(stdin)) && c != '\n')
        ;
    if (c != EOF)
        *w++ = c;
    if (!isalpha(c))
        {
        *w = '\0';
        return c;
        }
    for ( ; lim-- > 0; ++w)
        if (!isalnum(*w = fgetc(stdin)))
            {
            ungetc(*w, stdin);
            break;
            }
    *w = '\0';
    return *word;
    }

#define MAXWORD 100

int main()
    {
    char word[MAXWORD];
    unsigned lineno = 1;
    xrt x;

    while (getword(word, MAXWORD) != EOF)
        if (isalpha(word[0]))
            x.add(word, lineno);
        else if (word[0] == '\n')
            ++lineno;
    x.print();
    return 0;
    }

