Listing 3 - xrt member function definitions

//
// xrt.cpp - cross-reference table
//
#include <stdio.h>
#include <string.h>

#include "xrt.h"

class treenode
    {
public:
    treenode(const char *w, unsigned n);
    ~treenode();
    char *word;
    lns lines;
    xrt left, right;
    };

treenode::treenode(const char *w, unsigned n) : lines(n)
    {
    word = strcpy(new char[strlen(w) + 1], w);
    }

treenode::~treenode()
    {
    delete [] word;
    }

xrt::~xrt()
    {
    delete root;
    }

void xrt::add(const char *w, unsigned n)
    {
    int cond;

    if (root == 0)
        root = new treenode(w, n);
    else if ((cond = strcmp(w, root->word)) == 0)
        root->lines.add(n);
    else if (cond < 0)
        root->left.add(w, n);
    else
        root->right.add(w, n);
    }

void xrt::print()
    {
    if (root != 0)
        {
        root->left.print();
        printf("%12s:", root->word);
        root->lines.print();
        printf("\n");
        root->right.print();
        }
    }
