
LISTING 22 - Typical implementation of ::operator new and
::operator delete

// opnew.cpp
#include <stdlib.h>
#include <new.h>

void *operator new(size_t siz)
{
   // Get new_handler
    void (*new_handler)() = set_new_handler(0);
    set_new_handler(new_handler);

    for (;;)
    {
        // Return pointer upon success
        void *p = malloc(siz);
        if (p)
            return p;

        // If there is a handler, call it
        if (new_handler)
            new_handler();
        else
            return 0;
    }
}

void operator delete(void *p)
{
    if (p)
        free(p);
}
