LISTING 2 - The rest of the string class implementation
// str.cpp
#include <iostream.h>
#include <iomanip.h>
#include <string.h>
#include <assert.h>
#include "str2.h"

string& string::operator+=(const string& s2)
{
    if (s2.count > 0)
    {
        size_t new_count = count + s2.count;
        char *buf = new char[new_count + 1];

        memcpy(buf,data,count);
        memcpy(buf+count,s2.data,s2.count);
        buf[count = new_count] = '\0';
        delete [] data;
        data = buf;
    }
    return *this;
}

string operator+(const string& s1, const string& s2)
{
    string temp(s1);
    return temp += s2;
}

int operator==(const string& s1, const string& s2)
{
    return &s1 == &s2 ||
           s1.count == s2.count &&
           strcmp(s1.data,s2.data) == 0;
}

ostream& operator<<(ostream& os, const string& s1)
{
    os.write(s1.data,s1.count);
    return os;
}

istream& operator>>(istream& is, string& s1)
{
    const size_t BUFSIZ = 256;
    char buf[BUFSIZ];

    is.getline(buf,BUFSIZ);
    delete [] s1.data;
    s1.clone(buf);
    return is;
}

void string::clone(const char *s)
{
    // Assumes data is deallocated
    assert(s);
    count = strlen(s);
    data = new char[count + 1];
    strcpy(data,s);
}

