LISTING 1 - A simple string class
// str.h

#include <stddef.h>

class ostream;
class istream;

class string {
public:
     string();
     string(const char*);
    ~string();

     friend string operator+(const string&, const string&);
     string& operator+=(const string&);
     friend int operator==(const string&, const string&);
     friend int operator!=(const string&, const string&);
     friend ostream& operator<<(ostream&, const string&);
     friend istream& operator>>(istream&, string&);
     char& operator[](size_t);
     size_t length() const;

private:
     char* data;
     size_t count;
     void clone(const char *);
};

inline string::string()
{
     *(data = new char[1]) = '\0';
     count = 0;
}

inline string::string(const char *s)
{
     clone(s);
}

inline string::~string()
{
     delete [] data;
}

inline int operator!=(const string& s1, const string& s2)
{
     return !(s1 == s2);
}

inline char& string::operator[](size_t pos)
{
     return data[pos];
}

inline size_t string::length() const
{
     return count;
}
