LISTING 28 - Tests the Vector class
// tvector.cpp
#include <iostream.h>
#include "vector.h"

// A user-defined class to test Vector
class Foo
{
    long x;

public:
    Foo() : x(0)
    {
        cout << "Foo::Foo()\n";
    }

    Foo(int i) : x(i)
    {}

    Foo(const Foo& f) : x(f.x)
    {
        cout << "Foo::Foo(const Foo&)\n";
    }

    ~Foo()
    {
        cout << "Foo::~Foo()\n";
    }

    friend ostream& operator<<(ostream& os, const Foo& f)
    {
        cout << f.x; return os;
    }
};

main()
{
    // Instantiate a vector of ints
    Vector<int> v(5);
    for (int i = 0; i < 11; ++i)
        v += i;
    for (i = 0; i < v.length(); ++i)
        cout << v[i] << endl;

    // Instantiate a vector of Foo's
    Vector<Foo> v2;
    v2 += 0;
    v2 += 1;
    v2 += 2;
    for (i = 0; i < v2.length(); ++i)
        cout << v2[i] << endl;

    return 0;
}
