LISTING 7 - Illustrates virtual functions
// virt.cpp
#include <iostream.h>

// Base class
class B
{
public:
    virtual void f()
    {
        cout << "B::f" << endl;
    }
};

// Derived class
class D : public B
{
public:
    virtual void f()
    {
        cout << "D::f" << endl;
    }
};

main()
{
    B *bp[2];  // Heterogeneous array
    B b;
    D d;

    bp[0] = &b;
    bp[1] = &d;

    for (int i = 0; i < 2; ++i)
        bp[i]->f();
    return 0;
}

/* Output:
B::f
D::f
*/

