/* ----------------------------------------------------
 *  Listing 5
 *
 *  chandle.h
 *  Adds character-device specific capability to
 *  class IoctlHandle
 * ------------------------------------------------- */

#ifndef __CHANDLE_H
#define __CHANDLE_H
#include "iohandle.h"

//ANSI display information ......
struct ANSIdata   {
    char info;       //info level (=0)
    char zero_1;        //reserved (=0)
    int block_length;   //param block length
                        //(start at next field)
    int flags;      //0x0001 = intense
                    //0x0002 = blink
                    //other bits reserved (=0)
    char mode;      //1 = text, 2 = graphics
    char zero_2;    //reserved (=0)
    int numcolors;  //# colors (= 2**n, where
                    // n == 0, 1, 2, 4, 8;
                    // 0 == monochrome )
    int pix_cols;   //pixel columns
    int pix_rows;   //pixel rows
    int txt_cols;   //text columns
    int txt_rows;   //text rows
    };

class charHandle : public IoctlHandle   {
protected:
    int _cat;        //current device category
    charHandle( const char *device );  //constructor
    void handle_info( int, unsigned ); //set dev info
    unsigned ioctl_data( ioctl_cmd fn, unsigned count,
                                       void *buffer );
    int char_ioctl( char_cmd minor_code,
                    void *param_block    );
public:
    static charHandle *Init(const char *device );
    ~charHandle() { }   //~IoctlHandle() closes _handle
    int deviceCat(void) { return _cat; }
    unsigned setDeviceInfo( unsigned newinfo )
        {   handle_info( _handle, newinfo );
            return handleInfo();        }
    int isCooked( void)       //!0 if ASCII mode
        { return !(binary & _info);   }
    int isRaw( void )         //!0 if Binary mode
        { return  (binary & _info); }
    int hasIoctlChar(void)  { return ioctl & _info; }
    int deviceReadyIn(void )  //!0=ready, 0 not ready
        {   return inputStatus(); }
    int deviceReadyOut(void)  //!0=ready, 0 not ready
        {   return outputStatus(); }
    int sendIoctl( unsigned *count, void *data);
    int readIoctl( unsigned *count, void *data);
    unsigned busyCount( void );  //get count
    unsigned busyCount( unsigned count );  //set count
    int getANSIdata( struct ANSIdata *dis);
    int setANSIdata( struct ANSIdata *dis);
};  //.... end class charHandle
#endif // __CHANDLE_H
/* ----- End of File ------------------------------- */
