/* ----------------------------------------------------
 *  Listing 7
 *
 *  fhandle.h
 *  Adds file-specific capability to IoctlHandle
 * ------------------------------------------------- */

#ifndef __FHANDLE_H
#define __FHANDLE_H

#include "iohandle.h"

class fileHandle : public IoctlHandle  {
protected:
    fileHandle( const char *path )
                : IoctlHandle( path )  { }
    fileHandle( int handle )
                : IoctlHandle( handle )  { }
public:
    static fileHandle *Init(const char *path );
    static fileHandle *Init(int handle );
    ~fileHandle() { }

    //Return 0-based drive# for a file handle....
    int driveNumber(void )
        {   return (drive_number & _info); }

    int fileEof(void)    //returns !0 if at eof
        {   return !inputStatus();  }
};  //.... end class fileHandle

#endif  // __FHANDLE_H

/* ----- End of File ------------------------------- */
