/* ----------------------------------------------------
 *  Listing 2
 *
 *  iobase.cpp
 *  IOCTL Base class implementation
 * ------------------------------------------------- */

#include "iobase.h"

IoctlBase::IoctlBase()      {
    _iregs.h.ah = 0x30;   //Get MS-DOS version
    intdosx( &_iregs, &_oregs, &_sregs );
    _dos.ver.major = _oregs.h.al;
    _dos.ver.minor = _oregs.h.ah;
    _dos_error = 0;
}
void IoctlBase::int21_44h( ioctl_cmd code )     {
   /* DOS IOCTL (21h/44h) service call......  */
    _iregs.h.ah = 0x44;   //function number
    _iregs.h.al = code;   //subfunction
    intdosx( &_iregs, &_oregs, &_sregs );
    _dos_error = _oregs.x.cflag ? _oregs.x.ax : 0;
    if( _dos_error )
        IoctlError( _dos_error );
}
/* ----- End of File ------------------------------- */
