/* ----------------------------------------------------
 *  Listing 1
 *
 *  iobase.h
 *  IOCTL Base class definition
 * ------------------------------------------------- */

#ifndef  __IOBASE_H
#define  __IOBASE_H
#include <dos.h>

class IoctlBase    {
public:
    //DOS IOCTL subfunction codes .....
    enum ioctl_cmd    {
    get_handle_info,    set_handle_info,
    read_ioctl_char,    send_ioctl_char,
    read_ioctl_block,   send_ioctl_block,
    input_status,       output_status,
    drive_removable,    drive_remote,
    handle_remote,      sharing_retry,
    gen_ioctl_char,     gen_ioctl_block,
    get_log_drivemap,   set_log_drivemap,
    query_ioctl_char,   query_ioctl_block
    };
    //Minor function codes, Generic IOCTL
    //for character devices ....
    enum char_cmd {
    set_iter_count = 0x45,     get_iter_count = 0x65,
    select_code_page = 0x4a,   start_code_page = 0x4c,
    end_code_page = 0x4d,      query_code_page = 0x6a,
    query_prepare_list = 0x6b, set_display_mode = 0x5f,
    get_display_mode = 0x7f
    };
    //Minor function codes for, Generic IOCTL
    //for block devices. ....
    enum block_cmd {
    set_params = 0x40,         write_track = 0x41,
    format_and_verify = 0x42,  set_media_id = 0x46,
    set_access_flag = 0x47,    get_params = 0x60,
    read_track = 0x61,         verify_track = 0x62,
    get_media_id = 0x66,       get_access_flag = 0x67,
    sense_media_type = 0x68
    };
    IoctlBase();
    ~IoctlBase() { }
protected:
    //switch DOS major/minor version numbers
    //for direct version comparisons .........
    struct DOS_MM { unsigned char minor, major;};
    union   DOS_VERSION  { int version;
                           struct  DOS_MM   ver; };
    union DOS_VERSION _dos;
    int _dos_error;   //saved DOS error number
    union REGS _iregs, _oregs;
    struct SREGS _sregs;
    virtual void int21_44h(ioctl_cmd code );
    virtual void IoctlError( int ) { }  //error proc
};  //.... end class IoctlBase
#endif   //__IOBASE_H
/* ----- End of File ------------------------------- */
