/* ----------------------------------------------------
 *  Listing 4
 *
 *  iohandle.cpp
 *  Base class for handle-based IOCTL for character
 *  devices and files
 * ------------------------------------------------- */

#include <io.h>         //open()
#include <fcntl.h>
#include "iohandle.h"

#ifndef NDEBUG
#include <iostream.h>

void IoctlHandle::IoctlError( int errval )
{
    cerr << "*** class IoctlHandle: DOS error #"
         << errval << " encountered, subfunction #"
         << hex << _iregs.x.ax << dec << endl;
}
#endif      // NDEBUG

IoctlHandle::~IoctlHandle()     {
    if( _pathused )     //close() handle
            close( _handle );   //if path specified.
}
IoctlHandle::IoctlHandle( int handle )      {
    _info = handle_info( handle );
    _handle = _dos_error ? -1 : handle;
    _pathused = 0;
}
IoctlHandle::IoctlHandle( const char *path )    {
    int fh;
    if( (fh = open( path, O_RDWR )) != -1 )   {
            _info = handle_info( fh );
            _handle = fh;
            _pathused = 1;
            return;
    }
    _handle = -1;
    _pathused = 0;
}
IoctlHandle *IoctlHandle::Init( int fhandle )   {
   /* Return a pointer to new IoctlHandle object    */
    IoctlHandle *obj = new IoctlHandle( fhandle);
    if( obj->_handle == -1 )  {    //bad fhandle
            delete obj;
            return (IoctlHandle *) 0;
    }
    return obj;
}
IoctlHandle *IoctlHandle::Init(const char *path )   {
   /* Return a pointer to a new IoctlHandle object */
    IoctlHandle *obj = new IoctlHandle( path);
    if( obj->_handle == -1 )   {   //bad path
            delete obj;
            return (IoctlHandle *) 0;
    }
    return obj;
}
unsigned IoctlHandle::handle_info( int handle ) {
   /* Get device information word */
    _iregs.x.bx = handle;
    int21_44h(get_handle_info);
    return _oregs.x.dx;
}
int IoctlHandle::inputStatus(void)      {
   /* Return -1 if handle ready for input, else 0 */
    _iregs.x.bx = _handle;
    int21_44h(input_status);
    return (int) _oregs.h.al;
}
int IoctlHandle::outputStatus( void)    {
   /* Return -1 if handle ready for output, else 0 */
    _iregs.x.bx = _handle;
    int21_44h(output_status);
    return (int) _oregs.h.al;
}
int IoctlHandle::isRemote(void)    {
    _iregs.x.bx = _handle;
    int21_44h( handle_remote );
    return _oregs.x.dx & remote;  //!0 if remote
}
/* ----- End of File ------------------------------- */
