/* ----------------------------------------------------
 *  Listing 3
 *
 *  iohandle.h
 *  Base class for handle-based IOCTL for character
 *  devices and files
 * ------------------------------------------------- */

#ifndef __IOHANDLE_H
#define __IOHANDLE_H
#include "iobase.h"

class IoctlHandle : public IoctlBase {
protected:
    unsigned handle_info( int );      //get info
    virtual void IoctlError(int);
    IoctlHandle( int handle );      //constructor 1
    IoctlHandle( const char *path );  //constructor 2
    int _handle;        //validated handle
    int _pathused;   //!0 if Init( char *) called
    unsigned _info;     //handle info word
public:
    static IoctlHandle *Init( int handle );
    static IoctlHandle *Init(const char *);
    ~IoctlHandle();     //destructor

    //Format of handle information word ....
    enum file_info   {
    drive_number = 0x003f, //bits 0-5 =drive#
                           //(0-based, A=0)
                      //= drive containing the file.
    cleared = 0x0040,  //bit 6=1 if file cleared
                       // (i.e. not written to)
    file_bit = 0x0080,    //bit 7=0 if a file
    fixed = 0x0800,   //bit 11=1, media not removable
    noInherit = 0x1000,  //bit 12=1, no inherit (?)
    noCommit = 0x4000,  //bit 14=1, Date/time not set
			//on handle close operation
    remote = 0x8000     //bit 15=1 if file remote
    };
    enum device_info {
    std_in = 0x0001,    //bit 0=1 if std input
    std_out = 0x0002,   //bit 1=1 if std output
    std_nul = 0x0004,   //bit 2=1 if NUL device
    std_clk = 0x0008,   //bit 3=1 if CLOCK device
    use_int29h = 0x0010,  //use int 29h for single
                          //char text output.....
    binary = 0x0020,      //bit 5=0 if ASCII,
                          // =1 if binary
    eof = 0x0040,       //bit 6=0 if at EOF on input
    device_bit = 0x0080,    //bit 7=1 if a device
    network = 0x1000,  //bit 12=1 if network device
    ioctl = 0x4000  //bit 14=1 if driver can
                    //process IOCTL strings via
                    //subfunctions 02h & 03h
    };
    int readHandle(void) { return _handle; }
    int isFile( void )
        { return !(file_bit & _info);  }
    int isDevice( void )
        { return device_bit & _info;   }
    unsigned handleInfo(void)   //get & refresh _info
        {   _info = handle_info( _handle );
            return _info;       }
    int inputStatus( void );  //!0=ready, 0=not
    int outputStatus( void ); //!0=ready, 0=not
    int isRemote(void);  //File/device handle remote?
};  //.... end class IoctlHandle
#endif //__IOHANDLE_H
/* ----- End of File ------------------------------- */
