/* ----------------------------------------------------
 *  iostruct.h
 *
 *  Block IOCTL-related structures.
 *  Enable byte-packing of structures
 * ------------------------------------------------- */

#ifndef __IOSTRUCT_H
#define __IOSTRUCT_H

//BIOS parameter block ......
struct BPBlock  {
    int bps;    //bytes/sector
    char spc;   //sectors/cluster
    int rs;     //reserved sectors
    char nfat;  //#copies fat
    int rds;   //root dir size (#entries)
    unsigned stot; //total# sectors
    char md;    //media descriptor
    int spf;    //#sectors/fat
    int spt;    //#sectors/track
    int nheads; //#heads (sides)
    long nhid;  //hidden sectors
    long nsect;  //total sects if stot == 0
    };

struct DEVICEPARAMS  {
    char spfun;      //special function field
    char device_type;   //type of block device
    int device_attr;    //device attributes
    unsigned numcyl;    //total# cylinders
    char media_type;
    struct BPBlock bptab;
    //Offset to next field indicates location of
    //start of track layout table. Table length
    //in bytes = (sectors_per_track x 4) + 2 ....
    char beg_track_layout;
    };

struct RWBLOCK {
    char    spfun;      //special function = 0
    int     disk_head;
    int     disk_cylinder;  //cylinder# (0-based)
    int     first_sector;   //1st sect# (0-based)
    int     xfer_count;     //#sectors to transfer
    void far *xfer_buf;     //-> read/write buffer
    };

struct MID    {
    int info;       //information level (=0)
    unsigned long sernum;  //disk serial number
    char volume[11];    //disk volume label
    char fattype[8];    //file (fat) system type,
                        //either:
                        //"FAT12  " or "FAT16  "
    };

struct MTYPE {
    char flag;  //0 = media is NOT default type
                //1 = media is default type
    char type;  //2 = 720Kb disk
                //7 = 1.44Mb disk
                //9 = 2.88Mb disk
    };

struct SPECIALFUNC {
    char    spfunc;     //special function (=0)
    char    acc_flag;   //= 0 if access blocked;
                        //media not formatted
    };

struct FVBLOCK    {
    char spfunc;    //special functions:
                    //0 = Format/verify
                    //1 = chk for ROM support
                    //2 = Fast format (?)
    int  disk_head;     //head#
    int  disk_cylinder;  //cylinder# (0-based)
    int num_tracks; //#tracks to verify (used only
                    //if spfunc = 2)
    };

#endif   //__IOSTRUCT_H

/* ----- End of File ------------------------------- */
