

    /***********************************************
    *
    *       file d:\cips\boole.c
    *
    *       Functions: This file contains
    *          and_image
    *          or_image
    *          xor_image
    *          nand_image
    *          nor_image
    *          not_image
    *
    *       Purpose:
    *          These functions implement the basic
    *          Boolean algebra functions AND, OR,
    *          XOR, NAND, NOR, and NOT.
    *
    *       External Calls:
    *          wtiff.c - create_file_if_needed
    *                    write_array_into_tiff_image
    *          tiff.c - read_tiff_header
    *          rtiff.c - read_tiff_image
    *          numcvrt.c - get_integer
    *
    *       Modifications:
    *          3 March 1993 - created
    *
    ***********************************************/


#include "cips.h"



   /**************************************************
   *
   *   and_image(...
   *
   *   This function performs the Boolean AND 
   *   operation.  The output image = in1 AND in2.
   *   This works for 0 non-zero images.  If both
   *   in1 and in2 are non-zero, the output = in1.
   *
   ***************************************************/

and_image(in1_name, in2_name, out_name,
          the_image, out_image,
          il1, ie1, ll1, le1,
          il2, ie2, ll2, le2,
          il3, ie3, ll3, le3)
   char   in1_name[], in2_name[], out_name[];
   int    il1, ie1, ll1, le1,
          il2, ie2, ll2, le2,
          il3, ie3, ll3, le3;
   short  the_image[ROWS][COLS],
          out_image[ROWS][COLS];
{
   int    i, j, length, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_image(in1_name, the_image,
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image,
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         if( the_image[i][j] != 0   &&
             out_image[i][j] != 0)
             out_image[i][j] = the_image[i][j];
         else
             out_image[i][j] = 0;
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

} /* ends and_image */





   /**************************************************
   *
   *   or_image(...
   *
   *   This function performs the Boolean OR 
   *   operation.  The output image = in1 OR in2.
   *   This works for 0 non-zero images.  If both
   *   in1 and in2 are non-zero, the output = in1.
   *   If in1 is non-zero, the output = in1.
   *   If in1 is zero and in2 is non-zero, the
   *   output = in2.
   *
   ***************************************************/

or_image(in1_name, in2_name, out_name,
         the_image, out_image,
         il1, ie1, ll1, le1,
         il2, ie2, ll2, le2,
         il3, ie3, ll3, le3)
   char  in1_name[], in2_name[], out_name[];
   int   il1, ie1, ll1, le1,
         il2, ie2, ll2, le2,
         il3, ie3, ll3, le3;
   short the_image[ROWS][COLS],
         out_image[ROWS][COLS];
{
   int    i, j, length, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_image(in1_name, the_image,
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image,
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         if( the_image[i][j] != 0   ||
             out_image[i][j] != 0){
             if(the_image[i][j] != 0)
                out_image[i][j] = the_image[i][j];
             else
                out_image[i][j] = out_image[i][j];
         }
         else
             out_image[i][j] = 0;
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

} /* ends or_image */





   /**************************************************
   *
   *   xor_image(...
   *
   *   This function performs the Boolean XOR 
   *   operation.  The output image = in1 XOR in2.
   *   This works for 0 non-zero images.  If 
   *   in1 is non-zero and in2 is 0, output = in1. If
   *   in2 is non-zero and in1 is 0, output = in2.
   *   If both in1 and in2 are non-zero, output = 0.
   *   If both in1 and in2 are zero, output = 0.
   *
   ***************************************************/

xor_image(in1_name, in2_name, out_name,
          the_image, out_image,
          il1, ie1, ll1, le1,
          il2, ie2, ll2, le2,
          il3, ie3, ll3, le3)
   char   in1_name[], in2_name[], out_name[];
   int    il1, ie1, ll1, le1,
          il2, ie2, ll2, le2,
          il3, ie3, ll3, le3;
   short  the_image[ROWS][COLS],
          out_image[ROWS][COLS];
{
   int    i, j, length, width;
   short  answer;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_image(in1_name, the_image,
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image,
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         if( (the_image[i][j] != 0 &&
              out_image[i][j] == 0))
             answer = the_image[i][j];
         if( (the_image[i][j] == 0 &&
              out_image[i][j] != 0))
             answer = out_image[i][j];
         if( (the_image[i][j] == 0 &&
              out_image[i][j] == 0))
             answer = 0;
         if( (the_image[i][j] != 0 &&
              out_image[i][j] != 0))
             answer = 0;
         out_image[i][j] = answer;
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

} /* ends xor_image */





   /**************************************************
   *
   *   nand_image(...
   *
   *   This function performs the Boolean NAND 
   *   operation.  The output image = in1 NAND in2.
   *   This works for 0 non-zero images.  If both
   *   in1 and in2 are non-zero, the output = 0.
   *   Otherwise, the output = value.
   *
   ***************************************************/

nand_image(in1_name, in2_name, out_name,
           the_image, out_image,
           il1, ie1, ll1, le1,
           il2, ie2, ll2, le2,
           il3, ie3, ll3, le3, value)
   char    in1_name[], in2_name[], out_name[];
   int     il1, ie1, ll1, le1,
           il2, ie2, ll2, le2,
           il3, ie3, ll3, le3;
   short   the_image[ROWS][COLS],
           out_image[ROWS][COLS], value;
{
   int    i, j, length, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_image(in1_name, the_image,
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image,
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         if( the_image[i][j] != 0   &&
             out_image[i][j] != 0)
             out_image[i][j] = 0;
         else
             out_image[i][j] = value;
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

} /* ends nand_image */






   /**************************************************
   *
   *   nor_image(...
   *
   *   This function performs the Boolean NOR 
   *   operation.  The output image = in1 NOR in2.
   *   This works for 0 non-zero images.  If niether
   *   in1 nor in2 are non-zero, the output = value.
   *   That is, if both in1 and in2 are zero, the
   *   output = value.
   *
   ***************************************************/

nor_image(in1_name, in2_name, out_name,
          the_image, out_image,
          il1, ie1, ll1, le1,
          il2, ie2, ll2, le2,
          il3, ie3, ll3, le3, value)
   char   in1_name[], in2_name[], out_name[];
   int    il1, ie1, ll1, le1,
          il2, ie2, ll2, le2,
          il3, ie3, ll3, le3;
   short  the_image[ROWS][COLS],
          out_image[ROWS][COLS], value;
{
   int    i, j, length, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_image(in1_name, the_image,
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image,
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         if( the_image[i][j] == 0   &&
             out_image[i][j] == 0)
             out_image[i][j] = value;
         else
             out_image[i][j] = 0;
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

} /* ends nor_image */





   /**************************************************
   *
   *   not_image(...
   *
   *   This function will complement the values of the
   *   input image and put them into the output image.
   *   It will complement using a 0-value scheme where
   *   value is one of the input parameters.
   *
   ***************************************************/

not_image(in_name, out_name, the_image, out_image,
          il, ie, ll, le, value)
   char   in_name[], out_name[];
   int    il, ie, ll, le;
   short  the_image[ROWS][COLS],
          out_image[ROWS][COLS],
          value;
{
   int    i, j, length, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in_name, out_name, out_image);

   read_tiff_image(in_name, the_image, il, ie, ll, le);

   for(i=0; i<ROWS; i++)
      for(j=0; j<COLS; j++)
         out_image[i][j] = value;

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         if(the_image[i][j] == value)
             out_image[i][j] = 0;
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il, ie, ll, le);

} /* ends not_image */

