#include "cips.h"

non_zero_overlay(in1_name, in2_name, out_name,
          the_image, out_image,
          il1, ie1, ll1, le1,
          il2, ie2, ll2, le2,
          il3, ie3, ll3, le3)
   char   in1_name[], in2_name[], out_name[];
   int    il1, ie1, ll1, le1,
          il2, ie2, ll2, le2,
          il3, ie3, ll3, le3;
   short  the_image[ROWS][COLS],
          out_image[ROWS][COLS];
{
   int    i, j, length, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_image(in1_name, the_image,
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image,
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         if(the_image[i][j] != 0)
            out_image[i][j] = the_image[i][j];
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

} /* ends non_zero_overlay */

/****************************************************/

zero_overlay(in1_name, in2_name, out_name,
         the_image, out_image,
         il1, ie1, ll1, le1,
         il2, ie2, ll2, le2,
         il3, ie3, ll3, le3)
   char  in1_name[], in2_name[], out_name[];
   int   il1, ie1, ll1, le1,
         il2, ie2, ll2, le2,
         il3, ie3, ll3, le3;
   short the_image[ROWS][COLS],
         out_image[ROWS][COLS];
{
   int    i, j, length, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_image(in1_name, the_image,
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image,
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         if(the_image[i][j] == 0)
            out_image[i][j] = the_image[i][j];
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

} /* ends zero_overlay */

/****************************************************/

greater_overlay(in1_name, in2_name, out_name,
         the_image, out_image,
         il1, ie1, ll1, le1,
         il2, ie2, ll2, le2,
         il3, ie3, ll3, le3)
   char  in1_name[], in2_name[], out_name[];
   int   il1, ie1, ll1, le1,
         il2, ie2, ll2, le2,
         il3, ie3, ll3, le3;
   short the_image[ROWS][COLS],
         out_image[ROWS][COLS];
{
   int    i, j, length, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_image(in1_name, the_image,
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image,
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         if(the_image[i][j] > out_image[i][j])
            out_image[i][j] = the_image[i][j];
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

} /* ends greater_overlay */

/****************************************************/

less_overlay(in1_name, in2_name, out_name,
         the_image, out_image,
         il1, ie1, ll1, le1,
         il2, ie2, ll2, le2,
         il3, ie3, ll3, le3)
   char  in1_name[], in2_name[], out_name[];
   int   il1, ie1, ll1, le1,
         il2, ie2, ll2, le2,
         il3, ie3, ll3, le3;
   short the_image[ROWS][COLS],
         out_image[ROWS][COLS];
{
   int    i, j, length, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_image(in1_name, the_image,
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image,
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         if(the_image[i][j] < out_image[i][j])
            out_image[i][j] = the_image[i][j];
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

} /* ends less_overlay */

/****************************************************/

average_overlay(in1_name, in2_name, out_name,
         the_image, out_image,
         il1, ie1, ll1, le1,
         il2, ie2, ll2, le2,
         il3, ie3, ll3, le3)
   char  in1_name[], in2_name[], out_name[];
   int   il1, ie1, ll1, le1,
         il2, ie2, ll2, le2,
         il3, ie3, ll3, le3;
   short the_image[ROWS][COLS],
         out_image[ROWS][COLS];
{
   int    i, j, length, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_image(in1_name, the_image,
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image,
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         out_image[i][j] =
            (the_image[i][j] + out_image[i][j])/2;
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);
} /* ends average_overlay */
