#include "cips.h"

and_image(in1_name, in2_name, out_name,
          the_image, out_image,
          il1, ie1, ll1, le1,
          il2, ie2, ll2, le2,
          il3, ie3, ll3, le3)
   char   in1_name[], in2_name[], out_name[];
   int    il1, ie1, ll1, le1,
          il2, ie2, ll2, le2,
          il3, ie3, ll3, le3;
   short  the_image[ROWS][COLS],
          out_image[ROWS][COLS];
{
   int    i, j, length, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_image(in1_name, the_image,
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image,
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         if( the_image[i][j] != 0   &&
             out_image[i][j] != 0)
             out_image[i][j] = the_image[i][j];
         else
             out_image[i][j] = 0;
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

} /* ends and_image */

/*************************************************/

or_image(in1_name, in2_name, out_name,
         the_image, out_image,
         il1, ie1, ll1, le1,
         il2, ie2, ll2, le2,
         il3, ie3, ll3, le3)
   char  in1_name[], in2_name[], out_name[];
   int   il1, ie1, ll1, le1,
         il2, ie2, ll2, le2,
         il3, ie3, ll3, le3;
   short the_image[ROWS][COLS],
         out_image[ROWS][COLS];
{
   int    i, j, length, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_image(in1_name, the_image,
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image,
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         if( the_image[i][j] != 0   ||
             out_image[i][j] != 0){
             if(the_image[i][j] != 0)
                out_image[i][j] = the_image[i][j];
             else
                out_image[i][j] = out_image[i][j];
         }
         else
             out_image[i][j] = 0;
      }  /* ends loop over j */
   }  /* ends loop over i */
   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

} /* ends or_image */

/*************************************************/

xor_image(in1_name, in2_name, out_name,
          the_image, out_image,
          il1, ie1, ll1, le1,
          il2, ie2, ll2, le2,
          il3, ie3, ll3, le3)
   char   in1_name[], in2_name[], out_name[];
   int    il1, ie1, ll1, le1,
          il2, ie2, ll2, le2,
          il3, ie3, ll3, le3;
   short  the_image[ROWS][COLS],
          out_image[ROWS][COLS];
{
   int    i, j, length, width;
   short  answer;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_image(in1_name, the_image,
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image,
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         if( (the_image[i][j] != 0 &&
              out_image[i][j] == 0))
             answer = the_image[i][j];
         if( (the_image[i][j] == 0 &&
              out_image[i][j] != 0))
             answer = out_image[i][j];
         if( (the_image[i][j] == 0 &&
              out_image[i][j] == 0))
             answer = 0;
         if( (the_image[i][j] != 0 &&
              out_image[i][j] != 0))
             answer = 0;
         out_image[i][j] = answer;
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

} /* ends xor_image */

/*****************************************************/

nand_image(in1_name, in2_name, out_name,
           the_image, out_image,
           il1, ie1, ll1, le1,
           il2, ie2, ll2, le2,
           il3, ie3, ll3, le3, value)
   char    in1_name[], in2_name[], out_name[];
   int     il1, ie1, ll1, le1,
           il2, ie2, ll2, le2,
           il3, ie3, ll3, le3;
   short   the_image[ROWS][COLS],
           out_image[ROWS][COLS], value;
{
   int    i, j, length, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_image(in1_name, the_image,
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image,
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         if( the_image[i][j] != 0   &&
             out_image[i][j] != 0)
             out_image[i][j] = 0;
         else
             out_image[i][j] = value;
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

} /* ends nand_image */

/******************************************************/

nor_image(in1_name, in2_name, out_name,
          the_image, out_image,
          il1, ie1, ll1, le1,
          il2, ie2, ll2, le2,
          il3, ie3, ll3, le3, value)
   char   in1_name[], in2_name[], out_name[];
   int    il1, ie1, ll1, le1,
          il2, ie2, ll2, le2,
          il3, ie3, ll3, le3;
   short  the_image[ROWS][COLS],
          out_image[ROWS][COLS], value;
{
   int    i, j, length, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in1_name, out_name, out_image);

   read_tiff_image(in1_name, the_image,
                   il1, ie1, ll1, le1);
   read_tiff_image(in2_name, out_image,
                   il2, ie2, ll2, le2);

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         if( the_image[i][j] == 0   &&
             out_image[i][j] == 0)
             out_image[i][j] = value;
         else
             out_image[i][j] = 0;
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il3, ie3, ll3, le3);

} /* ends nor_image */

/*****************************************************/

not_image(in_name, out_name, the_image, out_image,
          il, ie, ll, le, value)
   char   in_name[], out_name[];
   int    il, ie, ll, le;
   short  the_image[ROWS][COLS],
          out_image[ROWS][COLS],
          value;
{
   int    i, j, length, width;
   struct tiff_header_struct image_header;

   create_file_if_needed(in_name, out_name, out_image);

   read_tiff_image(in_name, the_image, il, ie, ll, le);

   for(i=0; i<ROWS; i++)
      for(j=0; j<COLS; j++)
         out_image[i][j] = value;

   for(i=0; i<ROWS; i++){
      if ( (i%10) == 0) printf(" %d", i);
      for(j=0; j<COLS; j++){
         if(the_image[i][j] == value)
             out_image[i][j] = 0;
      }  /* ends loop over j */
   }  /* ends loop over i */

   write_array_into_tiff_image(out_name, out_image,
                               il, ie, ll, le);

} /* ends not_image */


